(globalThis.TURBOPACK || (globalThis.TURBOPACK = [])).push([typeof document === "object" ? document.currentScript : undefined,
"[project]/src/components/Functional/PhoneInput.tsx [client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "default",
    ()=>__TURBOPACK__default__export__
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/react/jsx-dev-runtime.js [client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$index$2e$js__$5b$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/react/index.js [client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$heroui$2f$button$2f$dist$2f$chunk$2d$WBUKVQRU$2e$mjs__$5b$client$5d$__$28$ecmascript$29$__$3c$export__button_default__as__Button$3e$__ = __turbopack_context__.i("[project]/node_modules/@heroui/button/dist/chunk-WBUKVQRU.mjs [client] (ecmascript) <export button_default as Button>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$heroui$2f$dropdown$2f$dist$2f$chunk$2d$XHRYXXZA$2e$mjs__$5b$client$5d$__$28$ecmascript$29$__$3c$export__dropdown_default__as__Dropdown$3e$__ = __turbopack_context__.i("[project]/node_modules/@heroui/dropdown/dist/chunk-XHRYXXZA.mjs [client] (ecmascript) <export dropdown_default as Dropdown>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$heroui$2f$dropdown$2f$dist$2f$chunk$2d$4LJ2IKXJ$2e$mjs__$5b$client$5d$__$28$ecmascript$29$__$3c$export__dropdown_trigger_default__as__DropdownTrigger$3e$__ = __turbopack_context__.i("[project]/node_modules/@heroui/dropdown/dist/chunk-4LJ2IKXJ.mjs [client] (ecmascript) <export dropdown_trigger_default as DropdownTrigger>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$heroui$2f$dropdown$2f$dist$2f$chunk$2d$UIQ4674R$2e$mjs__$5b$client$5d$__$28$ecmascript$29$__$3c$export__dropdown_menu_default__as__DropdownMenu$3e$__ = __turbopack_context__.i("[project]/node_modules/@heroui/dropdown/dist/chunk-UIQ4674R.mjs [client] (ecmascript) <export dropdown_menu_default as DropdownMenu>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$heroui$2f$menu$2f$dist$2f$chunk$2d$BIY4SM4Z$2e$mjs__$5b$client$5d$__$28$ecmascript$29$__$3c$export__menu_item_base_default__as__DropdownItem$3e$__ = __turbopack_context__.i("[project]/node_modules/@heroui/menu/dist/chunk-BIY4SM4Z.mjs [client] (ecmascript) <export menu_item_base_default as DropdownItem>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$heroui$2f$input$2f$dist$2f$chunk$2d$SSA7SXE4$2e$mjs__$5b$client$5d$__$28$ecmascript$29$__$3c$export__input_default__as__Input$3e$__ = __turbopack_context__.i("[project]/node_modules/@heroui/input/dist/chunk-SSA7SXE4.mjs [client] (ecmascript) <export input_default as Input>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$heroui$2f$image$2f$dist$2f$chunk$2d$BHGNW4BO$2e$mjs__$5b$client$5d$__$28$ecmascript$29$__$3c$export__image_default__as__Image$3e$__ = __turbopack_context__.i("[project]/node_modules/@heroui/image/dist/chunk-BHGNW4BO.mjs [client] (ecmascript) <export image_default as Image>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chevron$2d$down$2e$js__$5b$client$5d$__$28$ecmascript$29$__$3c$export__default__as__ChevronDown$3e$__ = __turbopack_context__.i("[project]/node_modules/lucide-react/dist/esm/icons/chevron-down.js [client] (ecmascript) <export default as ChevronDown>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$search$2e$js__$5b$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Search$3e$__ = __turbopack_context__.i("[project]/node_modules/lucide-react/dist/esm/icons/search.js [client] (ecmascript) <export default as Search>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$smartphone$2e$js__$5b$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Smartphone$3e$__ = __turbopack_context__.i("[project]/node_modules/lucide-react/dist/esm/icons/smartphone.js [client] (ecmascript) <export default as Smartphone>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$country$2d$list$2d$with$2d$dial$2d$code$2d$and$2d$flag$2f$dist$2f$index$2e$js__$5b$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/country-list-with-dial-code-and-flag/dist/index.js [client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$lodash$2f$debounce$2e$js__$5b$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/lodash/debounce.js [client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$helpers$2f$getters$2e$ts__$5b$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/src/helpers/getters.ts [client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$libphonenumber$2d$js$2f$min$2f$exports$2f$parsePhoneNumber$2e$js__$5b$client$5d$__$28$ecmascript$29$__$3c$export__parsePhoneNumber__as__parsePhoneNumberFromString$3e$__ = __turbopack_context__.i("[project]/node_modules/libphonenumber-js/min/exports/parsePhoneNumber.js [client] (ecmascript) <export parsePhoneNumber as parsePhoneNumberFromString>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$libphonenumber$2d$js$2f$min$2f$exports$2f$getExampleNumber$2e$js__$5b$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/libphonenumber-js/min/exports/getExampleNumber.js [client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$libphonenumber$2d$js$2f$examples$2e$mobile$2e$json$2e$js__$5b$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/libphonenumber-js/examples.mobile.json.js [client] (ecmascript)"); // needed for max length check
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2d$i18next$2f$dist$2f$es$2f$index$2e$js__$5b$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/react-i18next/dist/es/index.js [client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2d$i18next$2f$dist$2f$es$2f$useTranslation$2e$js__$5b$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/react-i18next/dist/es/useTranslation.js [client] (ecmascript)");
;
var _s = __turbopack_context__.k.signature();
;
;
;
;
;
;
;
;
;
const PhoneInput = ({ onPhoneChange, defaultCountry = "US", label = "Mobile", labelPlacement = "outside", variant = "flat", placeholder = "Phone number", isReadOnly = false, className = "", defaultValue = "" })=>{
    _s();
    const [state, setState] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$index$2e$js__$5b$client$5d$__$28$ecmascript$29$__["useState"])({
        selectedCountryCode: defaultCountry,
        phoneNumber: defaultValue,
        searchQuery: "",
        isDropdownOpen: false,
        selectedCountry: null,
        maxPhoneLength: undefined
    });
    const [filteredCountries, setFilteredCountries] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$index$2e$js__$5b$client$5d$__$28$ecmascript$29$__["useState"])([]);
    const [isLoading, setIsLoading] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$index$2e$js__$5b$client$5d$__$28$ecmascript$29$__["useState"])(false);
    const [error, setError] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$index$2e$js__$5b$client$5d$__$28$ecmascript$29$__["useState"])(null);
    const { t } = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2d$i18next$2f$dist$2f$es$2f$useTranslation$2e$js__$5b$client$5d$__$28$ecmascript$29$__["useTranslation"])();
    const allCountries = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$index$2e$js__$5b$client$5d$__$28$ecmascript$29$__["useMemo"])({
        "PhoneInput.useMemo[allCountries]": ()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$country$2d$list$2d$with$2d$dial$2d$code$2d$and$2d$flag$2f$dist$2f$index$2e$js__$5b$client$5d$__$28$ecmascript$29$__["default"].getAll?.() || []
    }["PhoneInput.useMemo[allCountries]"], []);
    const searchCountries = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$index$2e$js__$5b$client$5d$__$28$ecmascript$29$__["useCallback"])({
        "PhoneInput.useCallback[searchCountries]": (query)=>{
            const debouncedSearch = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$lodash$2f$debounce$2e$js__$5b$client$5d$__$28$ecmascript$29$__["default"])({
                "PhoneInput.useCallback[searchCountries].debouncedSearch": async (q)=>{
                    if (!q.trim()) {
                        setFilteredCountries(allCountries.slice(0, 5));
                        return;
                    }
                    try {
                        setIsLoading(true);
                        const countries = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$country$2d$list$2d$with$2d$dial$2d$code$2d$and$2d$flag$2f$dist$2f$index$2e$js__$5b$client$5d$__$28$ecmascript$29$__["default"].findByKeyword(q.toLowerCase());
                        setFilteredCountries(countries.slice(0, 5));
                    } catch  {
                        setError("Failed to search countries");
                        setFilteredCountries([]);
                    } finally{
                        setIsLoading(false);
                    }
                }
            }["PhoneInput.useCallback[searchCountries].debouncedSearch"], 300);
            debouncedSearch(query);
        }
    }["PhoneInput.useCallback[searchCountries]"], [
        allCountries
    ]);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$index$2e$js__$5b$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "PhoneInput.useEffect": ()=>{
            const fetchDefaultCountry = {
                "PhoneInput.useEffect.fetchDefaultCountry": async ()=>{
                    try {
                        setIsLoading(true);
                        const country = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$country$2d$list$2d$with$2d$dial$2d$code$2d$and$2d$flag$2f$dist$2f$index$2e$js__$5b$client$5d$__$28$ecmascript$29$__["default"].findOneByCountryCode(defaultCountry);
                        if (country) {
                            setState({
                                "PhoneInput.useEffect.fetchDefaultCountry": (prev)=>({
                                        ...prev,
                                        selectedCountryCode: country.code,
                                        selectedCountry: country
                                    })
                            }["PhoneInput.useEffect.fetchDefaultCountry"]);
                        } else {
                            setError("Invalid default country");
                        }
                    } catch  {
                        setError("Failed to load default country");
                    } finally{
                        setIsLoading(false);
                    }
                }
            }["PhoneInput.useEffect.fetchDefaultCountry"];
            fetchDefaultCountry();
        }
    }["PhoneInput.useEffect"], [
        defaultCountry
    ]);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$index$2e$js__$5b$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "PhoneInput.useEffect": ()=>{
            // fetch the real country code asynchronously
            const fetchUserCountry = {
                "PhoneInput.useEffect.fetchUserCountry": async ()=>{
                    try {
                        const countryCode = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$helpers$2f$getters$2e$ts__$5b$client$5d$__$28$ecmascript$29$__["getUserCountryCode"])();
                        const country = __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$country$2d$list$2d$with$2d$dial$2d$code$2d$and$2d$flag$2f$dist$2f$index$2e$js__$5b$client$5d$__$28$ecmascript$29$__["default"].findOneByCountryCode(countryCode);
                        if (country) {
                            setState({
                                "PhoneInput.useEffect.fetchUserCountry": (prev)=>({
                                        ...prev,
                                        selectedCountryCode: country.code,
                                        selectedCountry: country
                                    })
                            }["PhoneInput.useEffect.fetchUserCountry"]);
                        }
                    } catch (err) {
                        console.error("Failed to get user country code", err);
                    }
                }
            }["PhoneInput.useEffect.fetchUserCountry"];
            if (!defaultValue) {
                fetchUserCountry();
            }
        }
    }["PhoneInput.useEffect"], [
        defaultValue
    ]);
    // Get example number for max length
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$index$2e$js__$5b$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "PhoneInput.useEffect": ()=>{
            if (state.selectedCountryCode) {
                try {
                    const example = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$libphonenumber$2d$js$2f$min$2f$exports$2f$getExampleNumber$2e$js__$5b$client$5d$__$28$ecmascript$29$__["getExampleNumber"])(state.selectedCountryCode, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$libphonenumber$2d$js$2f$examples$2e$mobile$2e$json$2e$js__$5b$client$5d$__$28$ecmascript$29$__["default"]);
                    const maxLength = example ? example.nationalNumber.toString().length : undefined;
                    setState({
                        "PhoneInput.useEffect": (prev)=>({
                                ...prev,
                                maxPhoneLength: maxLength
                            })
                    }["PhoneInput.useEffect"]);
                } catch  {
                    setState({
                        "PhoneInput.useEffect": (prev)=>({
                                ...prev,
                                maxPhoneLength: undefined
                            })
                    }["PhoneInput.useEffect"]);
                    setError("Failed to fetch phone number format");
                }
            }
        }
    }["PhoneInput.useEffect"], [
        state.selectedCountryCode
    ]);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$index$2e$js__$5b$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "PhoneInput.useEffect": ()=>{
            if (state.isDropdownOpen) {
                searchCountries(state.searchQuery);
            }
        }
    }["PhoneInput.useEffect"], [
        state.searchQuery,
        state.isDropdownOpen,
        searchCountries
    ]);
    const handleCountryChange = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$index$2e$js__$5b$client$5d$__$28$ecmascript$29$__["useCallback"])({
        "PhoneInput.useCallback[handleCountryChange]": async (code)=>{
            try {
                const country = await __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$country$2d$list$2d$with$2d$dial$2d$code$2d$and$2d$flag$2f$dist$2f$index$2e$js__$5b$client$5d$__$28$ecmascript$29$__["default"].findOneByCountryCode(code);
                if (country) {
                    setState({
                        "PhoneInput.useCallback[handleCountryChange]": (prev)=>({
                                ...prev,
                                selectedCountryCode: code,
                                selectedCountry: country,
                                phoneNumber: "",
                                isDropdownOpen: false
                            })
                    }["PhoneInput.useCallback[handleCountryChange]"]);
                    onPhoneChange?.(code, state.phoneNumber, country.dialCode, country.name);
                }
            } catch  {
                setError("Failed to select country");
            }
        }
    }["PhoneInput.useCallback[handleCountryChange]"], [
        onPhoneChange,
        state.phoneNumber
    ]);
    const formatNumber = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$index$2e$js__$5b$client$5d$__$28$ecmascript$29$__["useCallback"])({
        "PhoneInput.useCallback[formatNumber]": (num, country)=>{
            try {
                const parsed = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$libphonenumber$2d$js$2f$min$2f$exports$2f$parsePhoneNumber$2e$js__$5b$client$5d$__$28$ecmascript$29$__$3c$export__parsePhoneNumber__as__parsePhoneNumberFromString$3e$__["parsePhoneNumberFromString"])(num, country.toUpperCase());
                return parsed ? parsed.formatNational() : num;
            } catch  {
                return num;
            }
        }
    }["PhoneInput.useCallback[formatNumber]"], []);
    const handlePhoneNumberChange = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$index$2e$js__$5b$client$5d$__$28$ecmascript$29$__["useCallback"])({
        "PhoneInput.useCallback[handlePhoneNumberChange]": (e)=>{
            const value = e.target.value;
            const cleanedValue = value.replace(/[^\d+]/g, "");
            const formattedValue = state.selectedCountryCode ? formatNumber(cleanedValue, state.selectedCountryCode) : cleanedValue;
            setState({
                "PhoneInput.useCallback[handlePhoneNumberChange]": (prev)=>({
                        ...prev,
                        phoneNumber: formattedValue
                    })
            }["PhoneInput.useCallback[handlePhoneNumberChange]"]);
            onPhoneChange?.(state.selectedCountryCode, cleanedValue, state.selectedCountry?.dialCode || "", state.selectedCountry?.name || "");
        }
    }["PhoneInput.useCallback[handlePhoneNumberChange]"], [
        formatNumber,
        onPhoneChange,
        state.selectedCountryCode,
        state.selectedCountry
    ]);
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
        className: `flex flex-col gap-2 ${className}`,
        children: [
            error && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                className: "text-tiny text-danger",
                children: error
            }, void 0, false, {
                fileName: "[project]/src/components/Functional/PhoneInput.tsx",
                lineNumber: 245,
                columnNumber: 17
            }, ("TURBOPACK compile-time value", void 0)),
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "flex w-full gap-2",
                children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$heroui$2f$input$2f$dist$2f$chunk$2d$SSA7SXE4$2e$mjs__$5b$client$5d$__$28$ecmascript$29$__$3c$export__input_default__as__Input$3e$__["Input"], {
                    name: "mobile",
                    isRequired: true,
                    isReadOnly: isReadOnly,
                    label: label,
                    labelPlacement: labelPlacement,
                    startContent: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$heroui$2f$dropdown$2f$dist$2f$chunk$2d$XHRYXXZA$2e$mjs__$5b$client$5d$__$28$ecmascript$29$__$3c$export__dropdown_default__as__Dropdown$3e$__["Dropdown"], {
                        isDisabled: isReadOnly,
                        className: "w-full p-2",
                        classNames: {
                            trigger: "max-h-[90%]"
                        },
                        isOpen: state.isDropdownOpen,
                        onOpenChange: (open)=>setState((prev)=>({
                                    ...prev,
                                    isDropdownOpen: open
                                })),
                        children: [
                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$heroui$2f$dropdown$2f$dist$2f$chunk$2d$4LJ2IKXJ$2e$mjs__$5b$client$5d$__$28$ecmascript$29$__$3c$export__dropdown_trigger_default__as__DropdownTrigger$3e$__["DropdownTrigger"], {
                                className: "p-1",
                                children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$heroui$2f$button$2f$dist$2f$chunk$2d$WBUKVQRU$2e$mjs__$5b$client$5d$__$28$ecmascript$29$__$3c$export__button_default__as__Button$3e$__["Button"], {
                                    variant: "flat",
                                    className: "min-w-[100px] justify-between bg-inherit p-2 min-h-full",
                                    endContent: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$chevron$2d$down$2e$js__$5b$client$5d$__$28$ecmascript$29$__$3c$export__default__as__ChevronDown$3e$__["ChevronDown"], {
                                        className: "text-default-500",
                                        size: 16
                                    }, void 0, false, {
                                        fileName: "[project]/src/components/Functional/PhoneInput.tsx",
                                        lineNumber: 268,
                                        columnNumber: 21
                                    }, void 0),
                                    "aria-label": "Select country",
                                    children: state.selectedCountry?.dialCode ? /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                        className: "flex items-center gap-2",
                                        children: [
                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$heroui$2f$image$2f$dist$2f$chunk$2d$BHGNW4BO$2e$mjs__$5b$client$5d$__$28$ecmascript$29$__$3c$export__image_default__as__Image$3e$__["Image"], {
                                                src: (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$helpers$2f$getters$2e$ts__$5b$client$5d$__$28$ecmascript$29$__["getFlagEmoji"])(state.selectedCountry.code),
                                                alt: `${state.selectedCountry.code} flag`,
                                                className: "h-5 w-6 rounded-sm"
                                            }, void 0, false, {
                                                fileName: "[project]/src/components/Functional/PhoneInput.tsx",
                                                lineNumber: 274,
                                                columnNumber: 23
                                            }, void 0),
                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                                className: "text-sm",
                                                children: state.selectedCountry.dialCode
                                            }, void 0, false, {
                                                fileName: "[project]/src/components/Functional/PhoneInput.tsx",
                                                lineNumber: 279,
                                                columnNumber: 23
                                            }, void 0)
                                        ]
                                    }, void 0, true, {
                                        fileName: "[project]/src/components/Functional/PhoneInput.tsx",
                                        lineNumber: 273,
                                        columnNumber: 21
                                    }, void 0) : "Select"
                                }, void 0, false, {
                                    fileName: "[project]/src/components/Functional/PhoneInput.tsx",
                                    lineNumber: 264,
                                    columnNumber: 17
                                }, void 0)
                            }, void 0, false, {
                                fileName: "[project]/src/components/Functional/PhoneInput.tsx",
                                lineNumber: 263,
                                columnNumber: 15
                            }, void 0),
                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$heroui$2f$dropdown$2f$dist$2f$chunk$2d$UIQ4674R$2e$mjs__$5b$client$5d$__$28$ecmascript$29$__$3c$export__dropdown_menu_default__as__DropdownMenu$3e$__["DropdownMenu"], {
                                "aria-label": "Country Selection",
                                className: "w-[280px] max-h-[200px] p-0",
                                closeOnSelect: true,
                                onSelectionChange: (keys)=>{
                                    const selectedKey = Array.from(keys)[0];
                                    if (selectedKey) handleCountryChange(selectedKey);
                                },
                                selectionMode: "single",
                                selectedKeys: [
                                    state.selectedCountryCode
                                ],
                                topContent: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "sticky top-0 z-10 border-b border-divider px-1 py-2 shadow-sm",
                                    children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$heroui$2f$input$2f$dist$2f$chunk$2d$SSA7SXE4$2e$mjs__$5b$client$5d$__$28$ecmascript$29$__$3c$export__input_default__as__Input$3e$__["Input"], {
                                        placeholder: "Search countries...",
                                        value: state.searchQuery,
                                        onValueChange: (value)=>setState((prev)=>({
                                                    ...prev,
                                                    searchQuery: value
                                                })),
                                        startContent: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$search$2e$js__$5b$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Search$3e$__["Search"], {
                                            className: "text-default-400",
                                            size: 16
                                        }, void 0, false, {
                                            fileName: "[project]/src/components/Functional/PhoneInput.tsx",
                                            lineNumber: 307,
                                            columnNumber: 25
                                        }, void 0),
                                        size: "sm",
                                        variant: "bordered",
                                        classNames: {
                                            inputWrapper: "border-1"
                                        },
                                        autoFocus: true,
                                        "aria-label": "Search countries"
                                    }, void 0, false, {
                                        fileName: "[project]/src/components/Functional/PhoneInput.tsx",
                                        lineNumber: 300,
                                        columnNumber: 21
                                    }, void 0)
                                }, void 0, false, {
                                    fileName: "[project]/src/components/Functional/PhoneInput.tsx",
                                    lineNumber: 299,
                                    columnNumber: 19
                                }, void 0),
                                classNames: {
                                    list: "overflow-y-auto max-h-[150px] p-0 px-1"
                                },
                                children: isLoading ? /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$heroui$2f$menu$2f$dist$2f$chunk$2d$BIY4SM4Z$2e$mjs__$5b$client$5d$__$28$ecmascript$29$__$3c$export__menu_item_base_default__as__DropdownItem$3e$__["DropdownItem"], {
                                    textValue: "Loading...",
                                    children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                        className: "text-default-400",
                                        children: "Loading..."
                                    }, void 0, false, {
                                        fileName: "[project]/src/components/Functional/PhoneInput.tsx",
                                        lineNumber: 323,
                                        columnNumber: 21
                                    }, void 0)
                                }, "loading", false, {
                                    fileName: "[project]/src/components/Functional/PhoneInput.tsx",
                                    lineNumber: 322,
                                    columnNumber: 19
                                }, void 0) : filteredCountries.length === 0 && state.searchQuery.trim() === "" ? /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$heroui$2f$menu$2f$dist$2f$chunk$2d$BIY4SM4Z$2e$mjs__$5b$client$5d$__$28$ecmascript$29$__$3c$export__menu_item_base_default__as__DropdownItem$3e$__["DropdownItem"], {
                                    className: "p-0 px-0.5",
                                    textValue: "Start typing to search countries",
                                    children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                        className: "text-default-400",
                                        children: "Start typing to search countries..."
                                    }, void 0, false, {
                                        fileName: "[project]/src/components/Functional/PhoneInput.tsx",
                                        lineNumber: 332,
                                        columnNumber: 21
                                    }, void 0)
                                }, "placeholder", false, {
                                    fileName: "[project]/src/components/Functional/PhoneInput.tsx",
                                    lineNumber: 327,
                                    columnNumber: 19
                                }, void 0) : filteredCountries.length === 0 ? /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$heroui$2f$menu$2f$dist$2f$chunk$2d$BIY4SM4Z$2e$mjs__$5b$client$5d$__$28$ecmascript$29$__$3c$export__menu_item_base_default__as__DropdownItem$3e$__["DropdownItem"], {
                                    className: "p-0",
                                    textValue: "No countries found",
                                    children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                        className: "text-default-400",
                                        children: "No countries found"
                                    }, void 0, false, {
                                        fileName: "[project]/src/components/Functional/PhoneInput.tsx",
                                        lineNumber: 342,
                                        columnNumber: 21
                                    }, void 0)
                                }, "no-results", false, {
                                    fileName: "[project]/src/components/Functional/PhoneInput.tsx",
                                    lineNumber: 337,
                                    columnNumber: 19
                                }, void 0) : filteredCountries.map((item)=>/*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$heroui$2f$menu$2f$dist$2f$chunk$2d$BIY4SM4Z$2e$mjs__$5b$client$5d$__$28$ecmascript$29$__$3c$export__menu_item_base_default__as__DropdownItem$3e$__["DropdownItem"], {
                                        textValue: `${item.name} (${item.dialCode})`,
                                        className: "p-2 my-1",
                                        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                            className: "flex items-center gap-2",
                                            children: [
                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$heroui$2f$image$2f$dist$2f$chunk$2d$BHGNW4BO$2e$mjs__$5b$client$5d$__$28$ecmascript$29$__$3c$export__image_default__as__Image$3e$__["Image"], {
                                                    src: (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$helpers$2f$getters$2e$ts__$5b$client$5d$__$28$ecmascript$29$__["getFlagEmoji"])(item.code),
                                                    alt: `${item.code} flag`,
                                                    className: "h-7 w-7 rounded-lg"
                                                }, void 0, false, {
                                                    fileName: "[project]/src/components/Functional/PhoneInput.tsx",
                                                    lineNumber: 352,
                                                    columnNumber: 25
                                                }, void 0),
                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                    className: "flex flex-col",
                                                    children: [
                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                                            className: "text-small",
                                                            children: item.name
                                                        }, void 0, false, {
                                                            fileName: "[project]/src/components/Functional/PhoneInput.tsx",
                                                            lineNumber: 358,
                                                            columnNumber: 27
                                                        }, void 0),
                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                                            className: "text-xs text-default-500",
                                                            children: `${item.dialCode} | ${item.code}`
                                                        }, void 0, false, {
                                                            fileName: "[project]/src/components/Functional/PhoneInput.tsx",
                                                            lineNumber: 359,
                                                            columnNumber: 27
                                                        }, void 0)
                                                    ]
                                                }, void 0, true, {
                                                    fileName: "[project]/src/components/Functional/PhoneInput.tsx",
                                                    lineNumber: 357,
                                                    columnNumber: 25
                                                }, void 0)
                                            ]
                                        }, void 0, true, {
                                            fileName: "[project]/src/components/Functional/PhoneInput.tsx",
                                            lineNumber: 351,
                                            columnNumber: 23
                                        }, void 0)
                                    }, item.code, false, {
                                        fileName: "[project]/src/components/Functional/PhoneInput.tsx",
                                        lineNumber: 346,
                                        columnNumber: 21
                                    }, void 0))
                            }, void 0, false, {
                                fileName: "[project]/src/components/Functional/PhoneInput.tsx",
                                lineNumber: 288,
                                columnNumber: 15
                            }, void 0)
                        ]
                    }, void 0, true, {
                        fileName: "[project]/src/components/Functional/PhoneInput.tsx",
                        lineNumber: 254,
                        columnNumber: 13
                    }, void 0),
                    endContent: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$smartphone$2e$js__$5b$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Smartphone$3e$__["Smartphone"], {
                        className: "text-default-400"
                    }, void 0, false, {
                        fileName: "[project]/src/components/Functional/PhoneInput.tsx",
                        lineNumber: 370,
                        columnNumber: 23
                    }, void 0),
                    value: state.phoneNumber,
                    onChange: handlePhoneNumberChange,
                    placeholder: placeholder,
                    className: "flex-1",
                    type: "tel",
                    maxLength: state.maxPhoneLength,
                    variant: variant,
                    classNames: {
                        inputWrapper: "pl-0",
                        errorMessage: "text-xs"
                    },
                    isDisabled: isLoading,
                    "aria-label": "Phone number",
                    isInvalid: state.phoneNumber.length > 0 && state.phoneNumber.length < (state.maxPhoneLength ?? 12),
                    errorMessage: ({ validationDetails })=>{
                        if (validationDetails.valueMissing) {
                            return t("phoneInput.error.required");
                        }
                        if (state.phoneNumber.length > 0 && state.phoneNumber.length < (state.maxPhoneLength ?? 12)) {
                            return t("phoneInput.error.invalidLength", {
                                max: state.maxPhoneLength
                            });
                        }
                        return "";
                    }
                }, void 0, false, {
                    fileName: "[project]/src/components/Functional/PhoneInput.tsx",
                    lineNumber: 247,
                    columnNumber: 9
                }, ("TURBOPACK compile-time value", void 0))
            }, void 0, false, {
                fileName: "[project]/src/components/Functional/PhoneInput.tsx",
                lineNumber: 246,
                columnNumber: 7
            }, ("TURBOPACK compile-time value", void 0))
        ]
    }, void 0, true, {
        fileName: "[project]/src/components/Functional/PhoneInput.tsx",
        lineNumber: 244,
        columnNumber: 5
    }, ("TURBOPACK compile-time value", void 0));
};
_s(PhoneInput, "jZDS0EaD9+oNwPgaQSBLeoJLSfs=", false, function() {
    return [
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2d$i18next$2f$dist$2f$es$2f$useTranslation$2e$js__$5b$client$5d$__$28$ecmascript$29$__["useTranslation"]
    ];
});
_c = PhoneInput;
const __TURBOPACK__default__export__ = PhoneInput;
var _c;
__turbopack_context__.k.register(_c, "PhoneInput");
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/src/components/Functional/PhoneInput.tsx [client] (ecmascript, next/dynamic entry)", ((__turbopack_context__) => {

__turbopack_context__.n(__turbopack_context__.i("[project]/src/components/Functional/PhoneInput.tsx [client] (ecmascript)"));
}),
]);

//# sourceMappingURL=src_components_Functional_PhoneInput_tsx_41f98167._.js.map