(globalThis.TURBOPACK || (globalThis.TURBOPACK = [])).push([typeof document === "object" ? document.currentScript : undefined,
"[project]/src/components/Cards/ProductCardAddButton.tsx [client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "default",
    ()=>__TURBOPACK__default__export__
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/react/jsx-dev-runtime.js [client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$index$2e$js__$5b$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/react/index.js [client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$heroui$2f$button$2f$dist$2f$chunk$2d$WBUKVQRU$2e$mjs__$5b$client$5d$__$28$ecmascript$29$__$3c$export__button_default__as__Button$3e$__ = __turbopack_context__.i("[project]/node_modules/@heroui/button/dist/chunk-WBUKVQRU.mjs [client] (ecmascript) <export button_default as Button>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$heroui$2f$toast$2f$dist$2f$chunk$2d$Z7B3SBEZ$2e$mjs__$5b$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/@heroui/toast/dist/chunk-Z7B3SBEZ.mjs [client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$shopping$2d$cart$2e$js__$5b$client$5d$__$28$ecmascript$29$__$3c$export__default__as__ShoppingCart$3e$__ = __turbopack_context__.i("[project]/node_modules/lucide-react/dist/esm/icons/shopping-cart.js [client] (ecmascript) <export default as ShoppingCart>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$plus$2e$js__$5b$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Plus$3e$__ = __turbopack_context__.i("[project]/node_modules/lucide-react/dist/esm/icons/plus.js [client] (ecmascript) <export default as Plus>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$minus$2e$js__$5b$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Minus$3e$__ = __turbopack_context__.i("[project]/node_modules/lucide-react/dist/esm/icons/minus.js [client] (ecmascript) <export default as Minus>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2d$redux$2f$dist$2f$react$2d$redux$2e$mjs__$5b$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/react-redux/dist/react-redux.mjs [client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2d$i18next$2f$dist$2f$es$2f$index$2e$js__$5b$client$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/react-i18next/dist/es/index.js [client] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2d$i18next$2f$dist$2f$es$2f$useTranslation$2e$js__$5b$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/react-i18next/dist/es/useTranslation.js [client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$routes$2f$api$2e$ts__$5b$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/src/routes/api.ts [client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$helpers$2f$updators$2e$ts__$5b$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/src/helpers/updators.ts [client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$helpers$2f$functionalHelpers$2e$ts__$5b$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/src/helpers/functionalHelpers.ts [client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$redux$2f$slices$2f$offlineCartSlice$2e$ts__$5b$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/src/lib/redux/slices/offlineCartSlice.ts [client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$lodash$2f$debounce$2e$js__$5b$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/lodash/debounce.js [client] (ecmascript)");
;
var _s = __turbopack_context__.k.signature();
;
;
;
;
;
;
;
;
;
;
const ProductCardAddButton = ({ product, defaultVariant, onOpenModal })=>{
    _s();
    const { t } = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2d$i18next$2f$dist$2f$es$2f$useTranslation$2e$js__$5b$client$5d$__$28$ecmascript$29$__["useTranslation"])();
    const dispatch = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2d$redux$2f$dist$2f$react$2d$redux$2e$mjs__$5b$client$5d$__$28$ecmascript$29$__["useDispatch"])();
    const cartData = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2d$redux$2f$dist$2f$react$2d$redux$2e$mjs__$5b$client$5d$__$28$ecmascript$29$__["useSelector"])({
        "ProductCardAddButton.useSelector[cartData]": (state)=>state.cart.cartData
    }["ProductCardAddButton.useSelector[cartData]"]);
    const offlineCartItems = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2d$redux$2f$dist$2f$react$2d$redux$2e$mjs__$5b$client$5d$__$28$ecmascript$29$__["useSelector"])({
        "ProductCardAddButton.useSelector[offlineCartItems]": (state)=>state.offlineCart.items
    }["ProductCardAddButton.useSelector[offlineCartItems]"]);
    const isLoggedIn = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2d$redux$2f$dist$2f$react$2d$redux$2e$mjs__$5b$client$5d$__$28$ecmascript$29$__["useSelector"])({
        "ProductCardAddButton.useSelector[isLoggedIn]": (state)=>state.auth.isLoggedIn
    }["ProductCardAddButton.useSelector[isLoggedIn]"]);
    // Find if this variant is already in cart (online or offline)
    const cartItem = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$index$2e$js__$5b$client$5d$__$28$ecmascript$29$__["useMemo"])({
        "ProductCardAddButton.useMemo[cartItem]": ()=>{
            if (isLoggedIn) {
                return cartData?.items?.find({
                    "ProductCardAddButton.useMemo[cartItem]": (item)=>item.product_variant_id === defaultVariant.id
                }["ProductCardAddButton.useMemo[cartItem]"]);
            } else {
                return offlineCartItems?.find({
                    "ProductCardAddButton.useMemo[cartItem]": (item)=>item.product_variant_id === defaultVariant.id
                }["ProductCardAddButton.useMemo[cartItem]"]);
            }
        }
    }["ProductCardAddButton.useMemo[cartItem]"], [
        cartData,
        offlineCartItems,
        defaultVariant.id,
        isLoggedIn
    ]);
    const [localQuantity, setLocalQuantity] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$index$2e$js__$5b$client$5d$__$28$ecmascript$29$__["useState"])(0);
    const [isUpdating, setIsUpdating] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$index$2e$js__$5b$client$5d$__$28$ecmascript$29$__["useState"])(false);
    // Sync with cart
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$index$2e$js__$5b$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "ProductCardAddButton.useEffect": ()=>{
            setLocalQuantity(cartItem?.quantity || 0);
        }
    }["ProductCardAddButton.useEffect"], [
        cartItem
    ]);
    // Check if product is simple (single variant) or variant (multiple variants)
    const isSimpleProduct = product.type === "simple" || product.variants.length === 1;
    // Debounced add to cart function
    const debouncedAddToCart = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$index$2e$js__$5b$client$5d$__$28$ecmascript$29$__["useMemo"])({
        "ProductCardAddButton.useMemo[debouncedAddToCart]": ()=>(0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$lodash$2f$debounce$2e$js__$5b$client$5d$__$28$ecmascript$29$__["default"])({
                "ProductCardAddButton.useMemo[debouncedAddToCart]": async (quantity)=>{
                    if (!isLoggedIn) {
                        // Handle offline cart
                        const offlineItemId = `${defaultVariant.id}`;
                        if (quantity === 0) {
                            // Remove from offline cart
                            dispatch((0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$redux$2f$slices$2f$offlineCartSlice$2e$ts__$5b$client$5d$__$28$ecmascript$29$__["removeOfflineCartItem"])(offlineItemId));
                            (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$heroui$2f$toast$2f$dist$2f$chunk$2d$Z7B3SBEZ$2e$mjs__$5b$client$5d$__$28$ecmascript$29$__["addToast"])({
                                title: t("cart_updated_title"),
                                description: t("cartItems.itemRemoved.description"),
                                color: "success"
                            });
                        } else if (cartItem) {
                            // Update existing offline cart item
                            dispatch((0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$lib$2f$redux$2f$slices$2f$offlineCartSlice$2e$ts__$5b$client$5d$__$28$ecmascript$29$__["updateOfflineCartItemQuantity"])({
                                id: offlineItemId,
                                quantity: quantity
                            }));
                            (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$heroui$2f$toast$2f$dist$2f$chunk$2d$Z7B3SBEZ$2e$mjs__$5b$client$5d$__$28$ecmascript$29$__["addToast"])({
                                title: t("cart_updated_title"),
                                description: t("cart_updated_description"),
                                color: "success"
                            });
                        } else {
                            // Add new item to offline cart using helper function
                            (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$helpers$2f$functionalHelpers$2e$ts__$5b$client$5d$__$28$ecmascript$29$__["handleOfflineAddToCart"])({
                                product: product,
                                variant: defaultVariant,
                                quantity: quantity,
                                renderToast: true
                            });
                        }
                        return;
                    }
                    setIsUpdating(true);
                    try {
                        let response;
                        if (cartItem) {
                            // Item already exists in cart
                            if (quantity === 0) {
                                // Remove item from cart when quantity is 0
                                response = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$routes$2f$api$2e$ts__$5b$client$5d$__$28$ecmascript$29$__["removeItemFromCart"])(cartItem.id);
                            } else {
                                // Update existing cart item quantity
                                response = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$routes$2f$api$2e$ts__$5b$client$5d$__$28$ecmascript$29$__["updateCartItemQuantity"])(cartItem.id, quantity);
                            }
                        } else {
                            // Add new item to cart
                            response = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$routes$2f$api$2e$ts__$5b$client$5d$__$28$ecmascript$29$__["addToCart"])({
                                product_variant_id: defaultVariant.id,
                                store_id: defaultVariant.store_id,
                                quantity: quantity
                            });
                        }
                        if (response.success) {
                            (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$heroui$2f$toast$2f$dist$2f$chunk$2d$Z7B3SBEZ$2e$mjs__$5b$client$5d$__$28$ecmascript$29$__["addToast"])({
                                title: t("cart_updated_title"),
                                description: t("cart_updated_description"),
                                color: "success"
                            });
                            await (0, __TURBOPACK__imported__module__$5b$project$5d2f$src$2f$helpers$2f$updators$2e$ts__$5b$client$5d$__$28$ecmascript$29$__["updateCartData"])(true, true);
                        } else {
                            (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$heroui$2f$toast$2f$dist$2f$chunk$2d$Z7B3SBEZ$2e$mjs__$5b$client$5d$__$28$ecmascript$29$__["addToast"])({
                                title: t("update_failed_title"),
                                description: response.message || t("update_failed_description"),
                                color: "danger"
                            });
                            setLocalQuantity(cartItem?.quantity || 0);
                        }
                    } catch (error) {
                        console.error(error);
                        (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$heroui$2f$toast$2f$dist$2f$chunk$2d$Z7B3SBEZ$2e$mjs__$5b$client$5d$__$28$ecmascript$29$__["addToast"])({
                            title: t("network_error_title"),
                            description: t("network_error_description"),
                            color: "danger"
                        });
                        setLocalQuantity(cartItem?.quantity || 0);
                    } finally{
                        setIsUpdating(false);
                    }
                }
            }["ProductCardAddButton.useMemo[debouncedAddToCart]"], 500)
    }["ProductCardAddButton.useMemo[debouncedAddToCart]"], [
        defaultVariant,
        isLoggedIn,
        cartItem,
        product,
        dispatch,
        t
    ]);
    const handleQuantityChange = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$index$2e$js__$5b$client$5d$__$28$ecmascript$29$__["useCallback"])({
        "ProductCardAddButton.useCallback[handleQuantityChange]": (newQuantity)=>{
            const minQuantity = product.minimum_order_quantity || 1;
            const maxQuantity = product.total_allowed_quantity || 999;
            const stock = defaultVariant.stock;
            if (newQuantity < 0) {
                return;
            }
            if (newQuantity > 0 && newQuantity < minQuantity) {
                (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$heroui$2f$toast$2f$dist$2f$chunk$2d$Z7B3SBEZ$2e$mjs__$5b$client$5d$__$28$ecmascript$29$__["addToast"])({
                    title: t("min_quantity_error_title"),
                    description: t("min_quantity_error_description", {
                        min: minQuantity
                    }),
                    color: "danger"
                });
                return;
            }
            if (newQuantity > maxQuantity) {
                (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$heroui$2f$toast$2f$dist$2f$chunk$2d$Z7B3SBEZ$2e$mjs__$5b$client$5d$__$28$ecmascript$29$__["addToast"])({
                    title: t("max_quantity_error_title"),
                    description: t("max_quantity_error_description", {
                        max: maxQuantity
                    }),
                    color: "danger"
                });
                return;
            }
            if (newQuantity > stock) {
                (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$heroui$2f$toast$2f$dist$2f$chunk$2d$Z7B3SBEZ$2e$mjs__$5b$client$5d$__$28$ecmascript$29$__["addToast"])({
                    title: t("stock_limit_error_title"),
                    description: t("stock_limit_error_description", {
                        stock
                    }),
                    color: "danger"
                });
                return;
            }
            setLocalQuantity(newQuantity);
            debouncedAddToCart(newQuantity);
        }
    }["ProductCardAddButton.useCallback[handleQuantityChange]"], [
        product,
        defaultVariant,
        debouncedAddToCart,
        t
    ]);
    const handleIncrement = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$index$2e$js__$5b$client$5d$__$28$ecmascript$29$__["useCallback"])({
        "ProductCardAddButton.useCallback[handleIncrement]": ()=>{
            const step = product.quantity_step_size || 1;
            handleQuantityChange(localQuantity + step);
        }
    }["ProductCardAddButton.useCallback[handleIncrement]"], [
        localQuantity,
        product.quantity_step_size,
        handleQuantityChange
    ]);
    const handleDecrement = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$index$2e$js__$5b$client$5d$__$28$ecmascript$29$__["useCallback"])({
        "ProductCardAddButton.useCallback[handleDecrement]": ()=>{
            const step = product.quantity_step_size || 1;
            handleQuantityChange(localQuantity - step);
        }
    }["ProductCardAddButton.useCallback[handleDecrement]"], [
        localQuantity,
        product.quantity_step_size,
        handleQuantityChange
    ]);
    const handleInitialAdd = ()=>{
        if (isSimpleProduct) {
            // For simple products, directly add to cart
            const minQuantity = product.minimum_order_quantity || 1;
            handleQuantityChange(minQuantity);
        } else {
            // For variant products, open modal
            onOpenModal();
        }
    };
    // Cleanup debounce on unmount
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$index$2e$js__$5b$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "ProductCardAddButton.useEffect": ()=>{
            return ({
                "ProductCardAddButton.useEffect": ()=>debouncedAddToCart.cancel()
            })["ProductCardAddButton.useEffect"];
        }
    }["ProductCardAddButton.useEffect"], [
        debouncedAddToCart
    ]);
    if (isSimpleProduct && localQuantity > 0) {
        return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
            className: "flex items-center gap-0.5 sm:gap-1",
            onClick: (e)=>e.stopPropagation(),
            children: [
                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$heroui$2f$button$2f$dist$2f$chunk$2d$WBUKVQRU$2e$mjs__$5b$client$5d$__$28$ecmascript$29$__$3c$export__button_default__as__Button$3e$__["Button"], {
                    isIconOnly: true,
                    size: "sm",
                    variant: "flat",
                    color: "primary",
                    className: "min-w-5 w-5 h-5 md:min-w-7 md:w-7 md:h-7",
                    onPress: handleDecrement,
                    isDisabled: isUpdating,
                    children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$minus$2e$js__$5b$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Minus$3e$__["Minus"], {
                        size: 14,
                        className: ""
                    }, void 0, false, {
                        fileName: "[project]/src/components/Cards/ProductCardAddButton.tsx",
                        lineNumber: 246,
                        columnNumber: 11
                    }, ("TURBOPACK compile-time value", void 0))
                }, void 0, false, {
                    fileName: "[project]/src/components/Cards/ProductCardAddButton.tsx",
                    lineNumber: 237,
                    columnNumber: 9
                }, ("TURBOPACK compile-time value", void 0)),
                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                    className: `text-xs md:text-sm font-semibold min-w-5  sm:min-w-6.5 text-center  ${isUpdating ? "opacity-60" : ""}`,
                    children: [
                        localQuantity,
                        isUpdating && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                            className: "ml-1 -mt-4 inline-block animate-spin text-xs",
                            children: "⏳"
                        }, void 0, false, {
                            fileName: "[project]/src/components/Cards/ProductCardAddButton.tsx",
                            lineNumber: 253,
                            columnNumber: 13
                        }, ("TURBOPACK compile-time value", void 0))
                    ]
                }, void 0, true, {
                    fileName: "[project]/src/components/Cards/ProductCardAddButton.tsx",
                    lineNumber: 248,
                    columnNumber: 9
                }, ("TURBOPACK compile-time value", void 0)),
                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$heroui$2f$button$2f$dist$2f$chunk$2d$WBUKVQRU$2e$mjs__$5b$client$5d$__$28$ecmascript$29$__$3c$export__button_default__as__Button$3e$__["Button"], {
                    isIconOnly: true,
                    size: "sm",
                    variant: "flat",
                    color: "primary",
                    className: "min-w-5 w-5 h-5 md:min-w-7 md:w-7 md:h-7",
                    onPress: handleIncrement,
                    isDisabled: isUpdating,
                    children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$plus$2e$js__$5b$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Plus$3e$__["Plus"], {
                        size: 14,
                        className: ""
                    }, void 0, false, {
                        fileName: "[project]/src/components/Cards/ProductCardAddButton.tsx",
                        lineNumber: 267,
                        columnNumber: 11
                    }, ("TURBOPACK compile-time value", void 0))
                }, void 0, false, {
                    fileName: "[project]/src/components/Cards/ProductCardAddButton.tsx",
                    lineNumber: 258,
                    columnNumber: 9
                }, ("TURBOPACK compile-time value", void 0))
            ]
        }, void 0, true, {
            fileName: "[project]/src/components/Cards/ProductCardAddButton.tsx",
            lineNumber: 233,
            columnNumber: 7
        }, ("TURBOPACK compile-time value", void 0));
    }
    // Initial "Add" button
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$client$5d$__$28$ecmascript$29$__["Fragment"], {
        children: [
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$heroui$2f$button$2f$dist$2f$chunk$2d$WBUKVQRU$2e$mjs__$5b$client$5d$__$28$ecmascript$29$__$3c$export__button_default__as__Button$3e$__["Button"], {
                className: "text-xs px-0 w-4 h-8 md:flex hidden",
                color: "primary",
                onPress: handleInitialAdd,
                radius: "lg",
                startContent: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$shopping$2d$cart$2e$js__$5b$client$5d$__$28$ecmascript$29$__$3c$export__default__as__ShoppingCart$3e$__["ShoppingCart"], {
                    className: "w-4 h-4"
                }, void 0, false, {
                    fileName: "[project]/src/components/Cards/ProductCardAddButton.tsx",
                    lineNumber: 281,
                    columnNumber: 23
                }, void 0),
                isDisabled: isUpdating,
                title: t("add"),
                children: t("add")
            }, void 0, false, {
                fileName: "[project]/src/components/Cards/ProductCardAddButton.tsx",
                lineNumber: 276,
                columnNumber: 7
            }, ("TURBOPACK compile-time value", void 0)),
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$heroui$2f$button$2f$dist$2f$chunk$2d$WBUKVQRU$2e$mjs__$5b$client$5d$__$28$ecmascript$29$__$3c$export__button_default__as__Button$3e$__["Button"], {
                className: "rounded-full md:hidden",
                color: "primary",
                isIconOnly: true,
                onPress: handleInitialAdd,
                size: "sm",
                isDisabled: isUpdating,
                children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$shopping$2d$cart$2e$js__$5b$client$5d$__$28$ecmascript$29$__$3c$export__default__as__ShoppingCart$3e$__["ShoppingCart"], {
                    size: 18
                }, void 0, false, {
                    fileName: "[project]/src/components/Cards/ProductCardAddButton.tsx",
                    lineNumber: 295,
                    columnNumber: 9
                }, ("TURBOPACK compile-time value", void 0))
            }, void 0, false, {
                fileName: "[project]/src/components/Cards/ProductCardAddButton.tsx",
                lineNumber: 287,
                columnNumber: 7
            }, ("TURBOPACK compile-time value", void 0))
        ]
    }, void 0, true);
};
_s(ProductCardAddButton, "gaiMkFrnlEF8L9D97hNAzFOYMtM=", false, function() {
    return [
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2d$i18next$2f$dist$2f$es$2f$useTranslation$2e$js__$5b$client$5d$__$28$ecmascript$29$__["useTranslation"],
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2d$redux$2f$dist$2f$react$2d$redux$2e$mjs__$5b$client$5d$__$28$ecmascript$29$__["useDispatch"],
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2d$redux$2f$dist$2f$react$2d$redux$2e$mjs__$5b$client$5d$__$28$ecmascript$29$__["useSelector"],
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2d$redux$2f$dist$2f$react$2d$redux$2e$mjs__$5b$client$5d$__$28$ecmascript$29$__["useSelector"],
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$react$2d$redux$2f$dist$2f$react$2d$redux$2e$mjs__$5b$client$5d$__$28$ecmascript$29$__["useSelector"]
    ];
});
_c = ProductCardAddButton;
const __TURBOPACK__default__export__ = ProductCardAddButton;
var _c;
__turbopack_context__.k.register(_c, "ProductCardAddButton");
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/src/components/Cards/ProductCardAddButton.tsx [client] (ecmascript, next/dynamic entry)", ((__turbopack_context__) => {

__turbopack_context__.n(__turbopack_context__.i("[project]/src/components/Cards/ProductCardAddButton.tsx [client] (ecmascript)"));
}),
]);

//# sourceMappingURL=src_components_Cards_ProductCardAddButton_tsx_df1aeb04._.js.map